'use client';

import { motion } from 'framer-motion';
import { 
  Mic2, 
  Building2, 
  Trophy, 
  PartyPopper,
  Handshake,
  Store,
  GraduationCap,
  Music,
  MoreHorizontal
} from 'lucide-react';
import { EventType } from '@/types/event';

interface CategorySectionProps {
  onCategoryClick: (category: EventType | 'all') => void;
  activeCategory: EventType | 'all';
}

const categories: { type: EventType | 'all'; label: string; icon: React.ReactNode; color: string }[] = [
  { type: 'all', label: 'All Events', icon: <MoreHorizontal className="w-5 h-5" />, color: '#E11D2E' },
  { type: 'conference', label: 'Conferences', icon: <Mic2 className="w-5 h-5" />, color: '#E11D2E' },
  { type: 'exhibition', label: 'Exhibitions', icon: <Building2 className="w-5 h-5" />, color: '#E11D2E' },
  { type: 'summit', label: 'Summits', icon: <Handshake className="w-5 h-5" />, color: '#E11D2E' },
  { type: 'festival', label: 'Festivals', icon: <PartyPopper className="w-5 h-5" />, color: '#E11D2E' },
  { type: 'trade-show', label: 'Trade Shows', icon: <Store className="w-5 h-5" />, color: '#E11D2E' },
  { type: 'concert', label: 'Concerts', icon: <Music className="w-5 h-5" />, color: '#E11D2E' },
  { type: 'sports', label: 'Sports', icon: <Trophy className="w-5 h-5" />, color: '#E11D2E' },
  { type: 'workshop', label: 'Workshops', icon: <GraduationCap className="w-5 h-5" />, color: '#E11D2E' },
];

/**
 * CategorySection component - Light Theme
 */
export default function CategorySection({ onCategoryClick, activeCategory }: CategorySectionProps) {
  return (
    <section id="categories" className="py-8 bg-white">
      <div className="overflow-x-auto scrollbar-hide -mx-4 px-4">
        <div className="flex items-center gap-3 min-w-max">
          {categories.map((category, index) => (
            <motion.button
              key={category.type}
              initial={{ opacity: 0, scale: 0.9 }}
              animate={{ opacity: 1, scale: 1 }}
              transition={{ duration: 0.3, delay: index * 0.05 }}
              onClick={() => onCategoryClick(category.type)}
              className={`
                flex items-center gap-2 px-4 py-3 rounded-xl border transition-all shadow-sm
                ${activeCategory === category.type
                  ? 'border-[#E11D2E] bg-[#FEE2E2] text-[#E11D2E]'
                  : 'border-gray-200 bg-white text-gray-600 hover:border-[#E11D2E]/50 hover:bg-gray-50'
                }
              `}
            >
              <div 
                className={`w-8 h-8 rounded-lg flex items-center justify-center ${
                  activeCategory === category.type ? 'bg-[#E11D2E]/10' : 'bg-gray-100'
                }`}
                style={{ 
                  color: activeCategory === category.type ? category.color : '#6B7280'
                }}
              >
                {category.icon}
              </div>
              <span className="text-sm font-medium whitespace-nowrap">
                {category.label}
              </span>
            </motion.button>
          ))}
        </div>
      </div>

      <style jsx>{`
        .scrollbar-hide::-webkit-scrollbar {
          display: none;
        }
        .scrollbar-hide {
          -ms-overflow-style: none;
          scrollbar-width: none;
        }
      `}</style>
    </section>
  );
}
